<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Integration\WHMCSVersioning;

class WHMCSv6 implements VersioningInterface
{
    /**
     * Just handler for easy access
     *
     * WHMCS global variable $aInt (reference!)
     *
     * @var instance of WHMCS_Admin or  WHMCS\Admin (for whmcs6)
     */
    protected $aInit;
    /**
     * Just handler for easy access
     *
     * WHMCS global variable $whmcs  (reference!)
     *
     * @var instance of WHMCS_Init or WHMCS\Init
     */
    protected $whmcs;
    /**
     * whmcs config handler  (reference!)
     *
     * @var array
     */
    protected $config;
    /**
     * whmcs lang
     *
     * @var reference to array
     */
    protected $lang;
    /**
     * whmcs admin lang
     *
     * @var reference to array
     */
    protected $adminLanguage;
    /**
     * data gathered from WHMCS
     *
     * @var array
     */
    protected $data = [];
    public function __construct($requestedVersion)
    {
        $data = [];
        global $whmcs;
        $this->whmcs =& $whmcs;
        global $aInt;
        $this->aInit =& $aInt;
        $data["adminSmartyVariables"] = $aInt->templatevars;
        $data["adminID"] = $_SESSION["adminid"];
        $data["adminLang"] = $aInt->language;
        $data["adminTemplate"] = $aInt->adminTemplate;
        global $customadminpath;
        $data["adminCustomPath"] = !empty($customadminpath) ? $customadminpath : "admin";
        global $downloads_dir;
        $data["downloadsDir"] = $downloads_dir;
        global $attachments_dir;
        $data["attachmentsDir"] = $attachments_dir;
        global $templates_compiledir;
        if(!$templates_compiledir) {
            $templates_compiledir = ROOTDIR . DS . "templates_c" . DS;
        }
        $data["templatesCompiled"] = $templates_compiledir;
        global $cc_encryption_hash;
        $data["CCencryptionHash"] = $cc_encryption_hash;
        global $db_host;
        $data["db_host"] = $db_host;
        global $db_name;
        $data["db_name"] = $db_name;
        global $db_username;
        $data["db_username"] = $db_username;
        global $db_password;
        $data["db_password"] = $db_password;
        global $db_port;
        $data["db_port"] = isset($db_port) ? $db_port : NULL;
        global $mysql_charset;
        $data["db_charset"] = !empty($mysql_charset) ? $mysql_charset : "utf8";
        $this->data = $data;
        global $CONFIG;
        $this->config =& $CONFIG;
        global $_LANG;
        $this->lang =& $_LANG;
        global $_ADMINLANG;
        $this->adminLanguage =& $_ADMINLANG;
    }
    public function getWHMCSinitObject()
    {
        return $this->whmcs;
    }
    public function getWHMCSadminObject()
    {
        return $this->aInit;
    }
    public function getConfig($key, $default = "")
    {
        return array_get($this->config, $key, $default);
    }
    public function getAdminLang($key, $default = "")
    {
        return array_get($this->adminLanguage, $key, $default);
    }
    public function getLang($key, $default = "")
    {
        return array_get($this->lang, $key, $default);
    }
    public function getAdminLanguage()
    {
        return array_get($this->data, "adminLang", "english");
    }
    public function getAdminTemplate()
    {
        return array_get($this->data, "adminTemplate", "blend");
    }
    public function getAdminID()
    {
        return array_get($this->data, "adminID", NULL);
    }
    public function isAdminLoggedIn()
    {
        return isset($this->data["adminID"]);
    }
    public function getAdminCustomPath()
    {
        return array_get($this->data, "adminCustomPath", "admin");
    }
    public function getMysqlConnection()
    {
        global $whmcsmysql;
        return $whmcsmysql;
    }
    public function getAttachmentsDir()
    {
        return array_get($this->data, "attachmentsDir", NULL);
    }
    public function getDownloadsDir()
    {
        return array_get($this->data, "downloadsDir", NULL);
    }
    public function getTemplatesCompiledDir()
    {
        return array_get($this->data, "templatesCompiled", NULL);
    }
    public function getCCencryptionHash()
    {
        return array_get($this->data, "CCencryptionHash", NULL);
    }
    public function getDBhost()
    {
        return array_get($this->data, "db_host", "");
    }
    public function getDBname()
    {
        return array_get($this->data, "db_name", "");
    }
    public function getDBport()
    {
        return array_get($this->data, "db_port", NULL);
    }
    public function getDBusername()
    {
        return array_get($this->data, "db_username", "");
    }
    public function getDBpassword()
    {
        return array_get($this->data, "db_password", "");
    }
    public function getDBcharset()
    {
        return array_get($this->data, "db_charset", "utf8");
    }
}

?>