<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Integration\Slim;

/**
 * Not significant changes
 * but we need to have ability, catch ours exceptions
 * whatever it is production or development mode, and standard behavior dont let us
 */
class SlimApp extends \Slim\Slim
{
    public function runInternalApi($route, $params = [])
    {
        $this->config("isWhmcsAPIcall", true);
        set_error_handler(["\\mgCRM2\\Integration\\Slim\\SlimApp", "handleErrors"]);
        register_shutdown_function(["\\mgCRM2\\Integration\\Slim\\SlimApp", "handleShutdown"]);
        $this->view(new ArrayView());
        $requestedRoute = $this->router->getNamedRoute($route);
        if(is_null($requestedRoute)) {
            throw new \Exception(sprintf("Requested Action: \"%s\" not recognized!", $route));
        }
        $this->environment = $this->environment->mock(["slim.input" => json_encode($params)]);
        if(is_null($params) || !is_array($params)) {
            $params = [];
        }
        $requestedRoute->setParams($params);
        $this->config("isWhmcsAPIcall", true);
        $requestedRoute->dispatch();
        return $this->view->all();
    }
    public function run()
    {
        set_error_handler(["\\mgCRM2\\Integration\\Slim\\SlimApp", "handleErrors"]);
        register_shutdown_function(["\\mgCRM2\\Integration\\Slim\\SlimApp", "handleShutdown"]);
        global $CRON;
        $this->add(new \mgCRM2\Middleware\PrettyExceptions(["debug" => $this->config("debug"), "cron" => $CRON]));
        $this->error = function ($e) {
            \mgCRM2\Middleware\PrettyExceptions::handleError($e);
        };
        $this->middleware[0]->call();
        list($status, $headers, $body) = $this->response->finalize();
        \Slim\Http\Util::serializeCookies($headers, $this->response->cookies, $this->settings);
        if(headers_sent() === false) {
            if(strpos(PHP_SAPI, "cgi") === 0) {
                header(sprintf("Status: %s", \Slim\Http\Response::getMessageForCode($status)));
            } else {
                header(sprintf("HTTP/%s %s", $this->config("http.version"), \Slim\Http\Response::getMessageForCode($status)));
            }
            foreach ($headers as $name => $value) {
                $hValues = explode("\n", $value);
                foreach ($hValues as $hVal) {
                    header($name . ": " . $hVal, false);
                }
            }
        }
        if(!$this->request->isHead()) {
            if(strpos($this->response->headers->get("Content-Type"), "application/json") !== false) {
                static::cleanOutputBuffer();
            }
            echo $body;
        }
        $this->applyHook("slim.after");
        restore_error_handler();
    }
    public static function handleErrors($errno, $errstr = "", $errfile = "", $errline = "")
    {
        if(!($errno & error_reporting())) {
            return NULL;
        }
        throw new \ErrorException($errstr, $errno, 0, $errfile, $errline);
    }
    protected static function cleanOutputBuffer()
    {
        $outputBuffering = ob_get_contents();
        if($outputBuffering !== false) {
            if(!empty($outputBuffering)) {
                ob_clean();
            } else {
                ob_start();
            }
        }
    }
    public static function handleShutdown()
    {
        $errfile = "unknown file";
        $errstr = "shutdown";
        $errno = E_CORE_ERROR;
        $errline = 0;
        $error = error_get_last();
        if($error !== NULL) {
            $errno = $error["type"];
            $errfile = $error["file"];
            $errline = $error["line"];
            $errstr = $error["message"];
            if($errno & E_ERROR) {
                try {
                    throw new \ErrorException($errstr, $errno, 0, $errfile, $errline);
                } catch (\ErrorException $ex) {
                    self::getInstance()->log->alert($e);
                }
                exit(sprintf("%s in %s on line %s ", $errstr, $errfile, $errline));
            }
        }
    }
    public function call()
    {
        try {
            if(isset($this->environment["slim.flash"])) {
                $this->view()->setData("flash", $this->environment["slim.flash"]);
            }
            $this->applyHook("slim.before");
            ob_start();
            $this->applyHook("slim.before.router");
            $dispatched = false;
            if($this->environment["SCRIPT_NAME"] != NULL) {
                $routeString = substr($this->request->getPath(), strpos($this->request->getPath(), "crm.php") + 7, strlen($this->request->getPath()));
                if(ends_with($routeString, "/")) {
                    $routeString = substr($routeString, 0, -1);
                }
            }
            $matchedRoutes = $this->router->getMatchedRoutes($this->request->getMethod(), $routeString);
            foreach ($matchedRoutes as $route) {
                try {
                    $this->applyHook("slim.before.dispatch");
                    $dispatched = $route->dispatch();
                    $this->applyHook("slim.after.dispatch");
                    if($dispatched) {
                        if(!$dispatched) {
                            $this->notFound();
                        }
                        $this->applyHook("slim.after.router");
                        $this->stop();
                    }
                } catch (\Slim\Exception\Pass $ex) {
                }
            }
        } catch (\Slim\Exception\Stop $ex) {
            $this->response()->write(ob_get_clean());
        } catch (\Exception $ex) {
            if($this->config("debug")) {
                throw $e;
            }
            try {
                $this->response()->write(ob_get_clean());
                $this->error($e);
            } catch (\Slim\Exception\Stop $ex) {
            }
        }
    }
}

?>