<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Integration\DebugBar\DataCollector;

class SlimRouteCollector extends \DebugBar\DataCollector\ConfigCollector
{
    /**
     * @var \Slim\Slim
     */
    protected $slim;
    public function __construct(\Slim\Slim $slim)
    {
        $this->slim = $slim;
        $this->setData($this->getRouteInfo());
    }
    public function getName()
    {
        return "route";
    }
    public function getRouteInfo()
    {
        $route = $this->slim->router->getCurrentRoute();
        $method = $this->slim->request->getMethod();
        $path = $this->slim->request->getPathInfo();
        $uri = $method . " " . $path;
        return ["uri" => $uri, "pattern" => $route->getPattern(), "params" => $route->getParams() ?: "-", "name" => $route->getName() ?: "-", "conditions" => $route->getConditions() ?: "-"];
    }
    public function getWidgets()
    {
        $name = $this->getName();
        $data = parent::getWidgets();
        $data["currentroute"] = ["icon" => "share", "tooltip" => "Route", "map" => $name . ".uri", "default" => "{}"];
        return $data;
    }
}

?>