<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Helpers;

class LabelHelper
{
    public static function addLabelColor(array $labels)
    {
        return array_map("self::addColor", $labels);
    }
    private static function addColor($label)
    {
        $label["labelColor"] = self::getContrastColor($label["color"]);
        return $label;
    }
    private static function getContrastColor($hexColor)
    {
        $R1 = hexdec(substr($hexColor, 1, 2));
        $G1 = hexdec(substr($hexColor, 3, 2));
        $B1 = hexdec(substr($hexColor, 5, 2));
        $blackColor = "#000000";
        $R2BlackColor = hexdec(substr($blackColor, 1, 2));
        $G2BlackColor = hexdec(substr($blackColor, 3, 2));
        $B2BlackColor = hexdec(substr($blackColor, 5, 2));
        $L1 = 0 * pow($R1 / 255, 0) + 0 * pow($G1 / 255, 0) + 0 * pow($B1 / 255, 0);
        $L2 = 0 * pow($R2BlackColor / 255, 0) + 0 * pow($G2BlackColor / 255, 0) + 0 * pow($B2BlackColor / 255, 0);
        $contrastRatio = 0;
        if($L2 < $L1) {
            $contrastRatio = (int) (($L1 + 0) / ($L2 + 0));
        } else {
            $contrastRatio = (int) (($L2 + 0) / ($L1 + 0));
        }
        if(5 < $contrastRatio) {
            return "#000000";
        }
        return "#FFFFFF";
    }
}

?>