<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Helpers;

/**
 * Use with SMS Center module cooperation
 *
 * @author Piotr Sarzyński <piotr.sa@modulesgarden.com> 
 */
class ContactImporter
{
    private $fields = [];
    private $contactTypes = [];
    private $contactStatuses = [];
    private $contactPriorities = [];
    private $mapStatic = [];
    private $mapCustomFields = [];
    /**
     * Keep single instance of translation object
     * We do not want to create many many translators object's
     *
     * @var Lang instance
     */
    private static $instance = ["csv" => "CSV", "xls" => "Excel5", "xlsx" => "Excel2007", "ods" => "OpenDocument"];
    private static $allowedFileExtension;
    private function __construct()
    {
    }
    private function __clone()
    {
    }
    public static function getInstance()
    {
        if(NULL === static::$instance) {
            static::$instance = new static();
        }
        return static::$instance;
    }
    protected function setNewLimits()
    {
        @ini_set("memory_limit", "512M");
        @ini_set("max_execution_time", 0);
        @set_time_limit(0);
    }
    public function isAllowedExtension($type)
    {
        return array_key_exists(strtolower($type), self::$allowedFileExtension);
    }
    public function getSummaryForUploadedFile()
    {
        $return = [];
        $file = ManageFiles::getHandlerToImportFile();
        if($file === false) {
            return $return;
        }
        $this->setNewLimits();
        $disableEmailDuplicateSetting = \mgCRM2\Repositories\Settings::getSingleParameter("disable_email_duplicate");
        $resourcesRepo = new \mgCRM2\Repositories\Resources();
        $usedMails = $resourcesRepo->getUsedEmailsList();
        $this->excel = \PhpOffice\PhpSpreadsheet\IOFactory::load($file);
        $rows = $this->excel->getActiveSheet()->toArray();
        $emailKey = $this->getEmailKeyFromHeaders($rows[0]);
        foreach ($rows as $index => $row) {
            $check = array_filter($row, function ($el) {
                return $el && $el !== " ";
            });
            $isEmailUsed = !empty($emailKey) && $disableEmailDuplicateSetting["disable_email_duplicate"] == 0 && in_array($row[$emailKey], $usedMails);
            if(!$check || $isEmailUsed) {
                unset($rows[$index]);
            }
        }
        $rowsCount = count($rows) - 1;
        if(is_numeric($rowsCount)) {
            $return["rows"] = $rowsCount;
        }
        return $return;
    }
    protected function getEmailKeyFromHeaders($headers)
    {
        $emailKey = array_search("Email", $headers);
        return $emailKey ?: array_search("email", $headers);
    }
    public function parseFirstRow()
    {
        $this->maxCol = $this->excel->getActiveSheet()->getHighestColumn();
        $nullValue = NULL;
        $calculateFormulas = true;
        $formatData = true;
        $returnCellRef = false;
        $header = $this->excel->getActiveSheet()->rangeToArray("A1:" . $this->maxCol . "1", $nullValue, $calculateFormulas, $formatData, $returnCellRef);
        $header = array_shift($header);
        $this->determinateColumnsOrder($header);
        $types = \mgCRM2\Models\ResourceType::withTrashed()->get();
        $statuses = \mgCRM2\Models\FieldStatus::all();
        foreach ($types as $type) {
            $this->contactTypes[$type->name] = $type->id;
        }
        foreach ($statuses as $status) {
            $this->contactStatuses[$status->name] = $status->id;
        }
        $this->contactPriorities = [\mgCRM2\Services\Language::translate("priority.1") => 1, \mgCRM2\Services\Language::translate("priority.2") => 2, \mgCRM2\Services\Language::translate("priority.3") => 3, \mgCRM2\Services\Language::translate("priority.4") => 4];
    }
    public function determinateColumnsOrder($row)
    {
        $this->fields = \mgCRM2\Models\Field::joinOptions()->get();
        $staticFieldNames = ["First Name" => "firstname", "Last Name" => "lastname", "Type" => "type_id", "Priority" => "priority", "Email" => "email", "Phone" => "phone", "Country" => "country", "Admin ID" => "admin_id", "Client ID" => "client_id", "Ticket ID" => "ticket_id", "Update Date" => "updated_at", "Creation Date" => "created_at", "Status" => "status_id"];
        foreach ($row as $index => $columnName) {
            $filterred = trim($columnName);
            if(array_key_exists($filterred, $staticFieldNames)) {
                array_set($this->mapStatic, $staticFieldNames[$filterred], $index);
            }
            foreach ($this->fields as $field) {
                if($filterred == $field->name) {
                    array_set($this->mapCustomFields, $field->id, $index);
                }
            }
        }
    }
    public function runImportFromFile()
    {
        $return = [];
        $file = ManageFiles::getHandlerToImportFile();
        if($file === false) {
            throw new \Exception("File not found");
        }
        $this->setNewLimits();
        $this->excel = \PhpOffice\PhpSpreadsheet\IOFactory::load($file);
        $this->parseFirstRow();
        $disableEmailDuplicateSetting = \mgCRM2\Repositories\Settings::getSingleParameter("disable_email_duplicate");
        $resourcesRepo = new \mgCRM2\Repositories\Resources();
        $usedMails = $resourcesRepo->getUsedEmailsList();
        $maxRow = $this->excel->getActiveSheet()->getHighestRow();
        $rows = $this->excel->getActiveSheet()->rangeToArray("A2:" . $this->maxCol . $maxRow, NULL, false, false, false);
        $counter = 0;
        foreach ($rows as $row) {
            try {
                $staticData = $this->mapRowByValues($row, $this->mapStatic);
                $dynamicFields = $this->mapRowByValues($row, $this->mapCustomFields);
                $staticData = $this->parseStaticVariables($staticData);
                $isEmailInUsage = $disableEmailDuplicateSetting["disable_email_duplicate"] == 0 && in_array($staticData["email"], $usedMails);
                if(!($isEmailInUsage || empty($staticData["name"]) || empty($staticData["lastname"]))) {
                    $newResource = new \mgCRM2\Models\Resource($staticData);
                    $newResource->save();
                    $this->assignLabels($row);
                    foreach ($this->fields as $field) {
                        try {
                            $field->createNewDataFromMigrationData($newResource, array_get($dynamicFields, $field->id, ""));
                        } catch (\Exception $ex) {
                        }
                    }
                    if($newResource->id) {
                        $counter++;
                    }
                }
            } catch (\Exception $ex) {
            }
        }
        return $counter;
    }
    private function assignLabels($row)
    {
        $labels = explode(",", $row[8]);
        if(!trim($labels[0])) {
            return NULL;
        }
        $user = $this->getLastUser();
        $clientLabelModel = new \mgCRM2\Models\ResourceLabel();
        foreach ($labels as $label) {
            if($this->labelExists($label)) {
                $data = ["label_id" => $label, "client_id" => $user["id"]];
                $clientLabelModel->create($data);
            }
        }
    }
    private function labelExists($id)
    {
        return \mgCRM2\Models\Label::find($id) ? true : false;
    }
    private function getLastUser()
    {
        $model = new \mgCRM2\Models\Resource();
        $users = $model->get()->toArray();
        return end($users);
    }
    public function mapRowByValues($data, $map)
    {
        $result = [];
        foreach ($map as $name => $key) {
            $result[$name] = array_get($data, $key, NULL);
        }
        return $result;
    }
    public function parseStaticVariables($data = [])
    {
        $updated = \Carbon\Carbon::parse(array_get($data, "update_date", false));
        $created = \Carbon\Carbon::parse(array_get($data, "created_at", false));
        $type_id = NULL;
        $priority = NULL;
        $status_id = NULL;
        $client_id = array_get($data, "client_id", NULL);
        if(!is_numeric($client_id) || $client_id == 0) {
            $client_id = NULL;
        }
        $ticket_id = array_get($data, "ticket_id", NULL);
        if(!is_numeric($ticket_id) || $ticket_id == 0) {
            $ticket_id = NULL;
        }
        $admin_id = array_get($data, "admin_id", NULL);
        if(!is_numeric($admin_id) || $admin_id == 0) {
            $admin_id = NULL;
        }
        if(isset($this->contactTypes[$data["type_id"]])) {
            $type_id = $this->contactTypes[$data["type_id"]];
        } else {
            $type = \mgCRM2\Models\ResourceType::where("deleted_at", NULL)->first();
            $type_id = $type->id;
        }
        if(isset($this->contactPriorities[$data["priority"]])) {
            $priority = $this->contactPriorities[$data["priority"]];
        }
        if(isset($this->contactStatuses[$data["status_id"]])) {
            $status_id = $this->contactStatuses[$data["status_id"]];
        }
        return ["name" => array_get($data, "firstname"), "lastname" => array_get($data, "lastname"), "email" => array_get($data, "email"), "phone" => array_get($data, "phone"), "country" => array_get($data, "country"), "type_id" => $type_id, "status_id" => $status_id, "priority" => $priority, "client_id" => $client_id, "ticket_id" => $ticket_id, "admin_id" => $admin_id, "created_at" => $created, "updated_at" => $updated, "deleted_at" => NULL];
    }
}

?>