<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Helpers;

/**
 * Export Resources to various format
 * baseds by library PHPExcel (http://www.codeplex.com/PHPExcel)
 *
 * @author Piotr Sarzyński <piotr.sa@modulesgarden.com> 
 */
class ContactExporter
{
    private $excel;
    /**
     * Requested format to genenerate exported data
     * @var string
     */
    private $format;
    /**
     * container for parsed to single array Resource with active fields
     * @var array
     */
    private $rows = [];
    /**
     * Single array with First row initializers.
     * Column names, like Name/Created Date/Status/Admin ID etc
     * check ContactExporter::getHeaderRow method
     * @var array
     */
    private $header = [];
    /**
     * Keep collection of all FieldData that will be renderred in first row
     * Basyd by this we sort resource data
     * @var eloquent collection
     */
    private $fields = [];
    /**
     * Allowed formats to generate
     * Key is format identifier
     * Value is PHPExcel Writer Interface to handle that format
     * @var array
     */
    private static $allowedFileExtension = ["csv" => "Csv", "xls" => "Xls", "xlsx" => "Xlsx", "ods" => "Ods", "pdf" => "Pdf"];
    /**
     * Keep single instance of translation object
     * We do not want to create many many translators object's
     *
     * @var Lang instance
     */
    private static $instance = ["csv" => "Csv", "xls" => "Xls", "xlsx" => "Xlsx", "ods" => "Ods", "pdf" => "Pdf"];
    private function __construct()
    {
    }
    private function __clone()
    {
    }
    public static function getInstance()
    {
        if(NULL === static::$instance) {
            static::$instance = new static();
        }
        return static::$instance;
    }
    protected function setNewLimits()
    {
        @ini_set("memory_limit", "-1");
        @ini_set("max_execution_time", 0);
        @set_time_limit(0);
    }
    public function isAllowedExtension($type)
    {
        return array_key_exists(strtolower($type), self::$allowedFileExtension);
    }
    public function getExtensionWriter($type)
    {
        if(!$this->isAllowedExtension($type)) {
            return false;
        }
        return self::$allowedFileExtension[strtolower($type)];
    }
    public function setUpCreatorData()
    {
        $this->excel->getProperties()->setCreator("Piotr Sarzyński")->setLastModifiedBy("Piotr Sarzyński")->setTitle("ModulesGarden CRM Exported Data")->setSubject("ModulesGarden CRM Exported Data")->setDescription("ModulesGarden CRM Exported Data. generated using PHP classes");
    }
    public function render()
    {
        if($this->format == "pdf") {
            $objWriter = new \PhpOffice\PhpSpreadsheet\Writer\Pdf\Tcpdf($this->excel);
        } else {
            $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($this->excel, $this->getExtensionWriter($this->format));
        }
        $objWriter->save("php://output");
        exit;
    }
    public function generateDataToExport($format)
    {
        $this->setNewLimits();
        $this->excel = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        $this->format = $format;
        if($format == "pdf") {
            $this->excel->getActiveSheet()->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);
            $this->excel->getActiveSheet()->getPageSetup()->setPaperSize(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A3);
        }
        $this->fieldDataRepo = new \mgCRM2\Repositories\FieldDatas();
        $this->setUpCreatorData();
        $this->getHeaderRow();
        $this->getDataRows();
        $this->excel->setActiveSheetIndex(0);
        $this->excel->getActiveSheet()->fromArray([$this->header], NULL, "A1");
        $this->excel->getActiveSheet()->fromArray($this->rows, NULL, "A2");
    }
    public function getHeaderRow()
    {
        $tmp = ["First Name", "Last Name", "Type", "Status", "Priority", "Email", "Phone", "Country", "Labels", "Admin ID", "Client ID", "Ticket ID", "Update Date", "Creation Date"];
        $this->fields = \mgCRM2\Models\Field::joinOptions()->activeFields()->orderred()->get();
        $customFields = $this->fields->map(function ($item, $key) {
            return $item->name;
        })->toArray();
        $this->header = array_merge($tmp, $customFields);
    }
    public function mapPriorityToLang($priority)
    {
        if(0 <= (int) $priority && (int) $priority <= 4 && !is_null($priority)) {
            return \mgCRM2\Services\Language::translate("priority." . $priority);
        }
        return \mgCRM2\Services\Language::translate("priority.0");
    }
    public function parseCarbonObjectToString(\Carbon\Carbon $date)
    {
        return $date->toDateTimeString();
    }
    public function syncStaticFieldsWithCustom($static, $custom)
    {
        $cf = $this->fields->map(function ($item) use($item) {
            return array_key_exists($item->id, $custom) ? $custom[$item->id] : " ";
        })->toArray();
        return array_merge($static, $cf);
    }
    public function parseResourceToRow(\mgCRM2\Models\Resource $r)
    {
        $tmp = [empty($r->name) ? " " : $r->name, empty($r->lastname) ? " " : $r->lastname, empty($r->type->name) ? " " : $r->type->name, empty($r->status->name) ? " " : $r->status->name, $this->mapPriorityToLang($r->priority), empty($r->email) ? " " : $r->email, empty($r->phone) ? " " : $r->phone, empty($r->country) ? " " : $r->country, $this->getLabels($r->id), empty($r->admin_id) ? " " : $r->admin_id, empty($r->client_id) ? " " : $r->client_id, empty($r->ticket_id) ? " " : $r->ticket_id, is_string($r->updated_at) ? $r->updated_at : $this->parseCarbonObjectToString($r->updated_at), is_string($r->created_at) ? $r->created_at : $this->parseCarbonObjectToString($r->created_at)];
        $customfields = \mgCRM2\Repositories\FieldDatas::toArrayForExport($r->fieldDatas);
        return $this->syncStaticFieldsWithCustom($tmp, $customfields);
    }
    private function getLabels($id)
    {
        $repo = new \mgCRM2\Repositories\Labels();
        $labels = $repo->getClientLabels($id);
        return empty($labels) ? " " : implode(",", $labels);
    }
    public function getDataRows()
    {
        $list = \mgCRM2\Models\Resource::with(["type", "status", "fieldDatas" => function ($query) {
            $query->joinField();
        }])->withTrashed()->get();
        foreach ($list as $item) {
            $this->rows[] = $this->parseResourceToRow($item);
        }
    }
}

?>