<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Helpers;

class AuthGoogle
{
    protected $client_id;
    protected $client_secret;
    protected $app;
    protected $path = "";
    protected $isSend = false;
    /**
     * @var Google_Client
     */
    protected static $client;
    public function __construct($data, $app)
    {
        $this->app = $app;
        if(empty($data)) {
            throw new \Exception("Empty Data in auth");
        }
        if(isset($data["client_id"])) {
            $this->client_id = $data["client_id"];
        }
        if(isset($data["client_secret"])) {
            $this->client_secret = $data["client_secret"];
        }
        $path = $this->app->container->get("settings");
        $this->path = $path["appInternalModuleDir"] . "app/Storage/";
        $this->generationJSONfile();
    }
    private function getToken()
    {
        $tokenJson = $this->path . "token.json";
        try {
            return file_get_contents($tokenJson);
        } catch (\Exception $ex) {
            return false;
        }
    }
    public function setToken($token)
    {
        $this->deleteToken();
        $tokenJson = $this->path . "token.json";
        $fp = fopen($tokenJson, "w");
        fwrite($fp, json_encode($token));
        fclose($fp);
    }
    public function deleteToken()
    {
        $tokenJson = $this->path . "token.json";
        if(file_exists($tokenJson)) {
            unlink($tokenJson);
        }
        return $this;
    }
    public function isSend()
    {
        return $this->isSend;
    }
    private function generationJSONfile()
    {
        $connectJson = $this->path . "google_auth.json";
        if(file_exists($connectJson)) {
            unlink($connectJson);
        }
        $lastWorld = $_SERVER["SCRIPT_NAME"];
        if(substr($lastWorld, 0, 1) == "/") {
            $url = $_SERVER["HTTP_HOST"] . $lastWorld;
        } else {
            $url = $_SERVER["HTTP_HOST"] . "/" . $lastWorld;
        }
        if(strpos($url, "http://") === false && strpos($url, "https://") === false) {
            $url = (isset($_SERVER["HTTPS"]) && strtoupper($_SERVER["HTTPS"]) == "ON" ? "https://" : "http://") . $url;
        }
        $url .= "/api/settings/general/auth/google/json";
        $response = [];
        $response["installed"] = ["auth_uri" => "https://accounts.google.com/o/oauth2/auth", "token_uri" => "https://accounts.google.com/o/oauth2/token", "auth_provider_x509_cert_url" => "https://www.googleapis.com/oauth2/v1/certs", "client_id" => $this->client_id, "client_secret" => $this->client_secret, "redirect_uris" => [$url]];
        $fp = fopen($connectJson, "w");
        fwrite($fp, json_encode($response));
        fclose($fp);
    }
    public function createUrl()
    {
        $client = $this->getClient();
        $token = $this->getToken();
        if($token && isset($token) && $token != "") {
            $client->setAccessToken($token);
            $this->refreshToken();
            return "#!/settings/general/followups";
        }
        $authUrl = $client->createAuthUrl();
        return $authUrl;
    }
    public function refreshToken()
    {
        if(self::$client == NULL) {
            $this->getClient();
        }
        if(self::$client->isAccessTokenExpired()) {
            self::$client->fetchAccessTokenWithRefreshToken(self::$client->getRefreshToken());
            $this->setToken(self::$client->getAccessToken());
        }
    }
    public function getClient($isRefresh = false)
    {
        if(self::$client != NULL) {
            $client = self::$client;
        } else {
            $client = new \Google_Client();
            $client->setAuthConfig($this->path . "google_auth.json");
            $client->setScopes(\Google_Service_Calendar::CALENDAR);
            $client->setIncludeGrantedScopes(true);
            $client->setAccessType("offline");
            $client->setApprovalPrompt("force");
            $token = $this->getToken();
            if($token && isset($token) && $token != "") {
                $client->setAccessToken($token);
                $this->isSend = false;
            } else {
                $this->isSend = true;
            }
            self::$client = $client;
        }
        if($isRefresh) {
            $this->refreshToken();
        }
        return $client;
    }
}

?>