<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers;

class ImportClients extends Source\AbstractController
{
    const IMPORT_CLIENT_LIMIT = 100;
    public function run()
    {
        $this->addMessage("Cron Start");
        $this->importClients();
        $this->addMessage("Cron Stop");
        $this->output();
    }
    protected function addMessage($msg)
    {
        $this->messages[] = $msg;
        if($this->isInCLIMode()) {
            echo $msg . "\r\n";
        } else {
            echo $msg;
            echo "<br />";
        }
    }
    public function isInCLIMode()
    {
        return php_sapi_name() == "cli" && empty($_SERVER["REMOTE_ADDR"]);
    }
    protected function output()
    {
        exit;
    }
    protected function importClients()
    {
        $updateIndex = 0;
        $createIndex = 0;
        $query = \mgCRM2\Models\Whmcs\Client::leftJoin("crm_resources", "crm_resources.email", "=", "tblclients.email")->where("crm_resources.client_id", "=", NULL)->addSelect(["tblclients.id as id", "tblclients.email as email", "tblclients.firstname as firstname", "tblclients.lastname as lastname", "tblclients.country as country", "tblclients.phonenumber as phonenumber", "crm_resources.id as resId"]);
        $clients = $query->limit(self::IMPORT_CLIENT_LIMIT)->get();
        foreach ($clients as $key => $value) {
            if(!$value->resId) {
                $this->createLead($value, $createIndex);
            } else {
                $this->relateLead($value, $updateIndex);
            }
        }
        if($clients->count()) {
            echo $updateIndex . " leads have been updated \r\n";
            echo $createIndex . " leads have been created \r\n";
        }
    }
    private function relateLead($client, &$index)
    {
        \mgCRM2\Models\Resource::where("id", $client->resId)->update(["client_id" => $client->id]);
        $index++;
    }
    private function createLead($client, &$index)
    {
        $lead = ["name" => $client->firstname, "lastname" => $client->lastname, "email" => $client->email, "phone" => $client->phonenumber, "priority" => 1, "type_id" => 1, "client_id" => $client->id, "country" => $client->country, "status_id" => 1];
        \mgCRM2\Models\Resource::create($lead);
        $index++;
    }
}

?>