<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Statistics;

/**
 * Class to maintain actions for single lead instance
 */
class TotalPerMonth extends \mgCRM2\Controllers\Source\AbstractController
{
    protected $adminID = false;
    protected $year;
    protected $month;
    protected $requestData = [];
    public function __construct()
    {
        parent::__construct();
        $this->requestData = json_decode($this->app->request->getBody(), true);
        $this->adminID = array_get($this->requestData, "admin", false);
        $this->year = array_get($this->requestData, "year", date("Y"));
        $this->year = intval($this->year);
        $this->month = array_get($this->requestData, "month", date("n"));
        $this->month = intval($this->month);
    }
    public function get()
    {
        try {
            $builder = new \mgCRM2\Helpers\StatisticsBuilder($this->adminID);
            $result = $builder->getTotalRecordsInMonth($this->year, $this->month, $this->requestData);
            return $this->returnData($result);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>