<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Settings;

class StatusFollowups extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\FollowupStatuses();
    }
    public function get()
    {
        try {
            $groups = $this->repository->getOrderred();
            return $this->returnData($groups->toArray());
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function reorder()
    {
        try {
            $json = $this->app->request->getBody();
            $data = json_decode($json, true);
            $newOrder = array_flip(array_get($data, "order", []));
            if($this->repository->reorder($newOrder)) {
                $return = ["status" => "success", "msg" => "Order Has has been updated"];
            } else {
                throw new \Exception("Something went wrong.");
            }
        } catch (\Exception $ex) {
            $this->app->response->setStatus(404);
            $return = ["status" => "error", "msg" => $e->getMessage()];
        }
        return $this->returnData($return);
    }
    public function addStatus()
    {
        $json = $this->app->request->getBody();
        $data = json_decode($json, true);
        if(!$data["order"]) {
            $data["order"] = $this->repository->getNextOrderNumber();
        }
        try {
            $new = $this->repository->create($data);
            if($new) {
                $return = ["status" => "success", "msg" => "New Status has been created", "new" => $new->toArray()];
            } else {
                throw new \Exception("Something went wrong.");
            }
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function deleteStatus($id)
    {
        try {
            $result = $this->repository->deleteStatus($id);
            if(!$result) {
                throw new \Exception("Something Went Wrong. Could not deleted Status.");
            }
            $return = ["status" => "success", "msg" => "Follow-up Status has been deleted"];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function updateStatus($id)
    {
        $data = json_decode($this->app->request->getBody(), true);
        try {
            $result = $this->repository->updateSingleParamInModel($id, $data);
            $return = ["status" => "success", "msg" => "Group has been updated", "new" => $result->toArray()];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
}

?>