<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Settings;

/**
 * Class to maintain actions for single lead instance
 */
class ManageSettings extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\Settings();
    }
    public function query()
    {
        try {
            $statuses = $this->repository->get();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($statuses->toArray());
    }
    public function updateFieldsMap()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(!empty($requestData)) {
                $model = \mgCRM2\Models\Setting::where("name", "=", "fields_map")->where("admin_id", "=", "0")->first();
                if(is_null($model)) {
                    $model = new \mgCRM2\Models\Setting(["name" => "fields_map", "admin_id" => 0]);
                }
                $model->value = $requestData;
                $model->save();
                return $this->returnData(["status" => "success", "msg" => "The mapping configuration has been updated successfully"]);
            }
            throw new \Exception("Setting not found");
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getFieldsMap()
    {
        try {
            $mapped = \mgCRM2\Models\Setting::where("name", "=", "fields_map")->where("admin_id", "=", "0")->first();
            return $this->returnData(["status" => "success", "value" => is_null($mapped) ? [] : $mapped->value]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>