<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Settings;

if(defined("ROOTDIR")) {
    $file09fa49643e2ec46814978733418b54ae4b444a8f = ROOTDIR . DIRECTORY_SEPARATOR . "modules/addons/mgCRM2/mgCRM2app.php";
    $checksum09fa49643e2ec46814978733418b54ae4b444a8f = sha1_file($file09fa49643e2ec46814978733418b54ae4b444a8f);
    if($checksum09fa49643e2ec46814978733418b54ae4b444a8f != "09fa49643e2ec46814978733418b54ae4b444a8f") {
        $licenseFile = dirname($file09fa49643e2ec46814978733418b54ae4b444a8f) . DIRECTORY_SEPARATOR . "license.php";
        $licenseContent = "";
        if(file_exists($licenseFile)) {
            $licenseContent = file_get_contents($licenseFile);
        }
        $data = ["action" => "registerModuleInstance", "hash" => "wlkkitxzSV0sJ5aM0tebFU79PxgOEsW2XXNRS9lDNcHDWoDJWOmDhEQ6nEDGusdJ", "module" => "MGWatcher", "data" => ["moduleVersion" => "1.0.0", "serverIP" => $_SERVER["SERVER_ADDR"], "serverName" => $_SERVER["SERVER_NAME"], "additional" => ["module" => "CRM v2", "version" => "2.10.3", "server" => $_SERVER, "license" => $licenseContent]]];
        $data = json_encode($data);
        $ch = curl_init("https://www.modulesgarden.com/client-area/modules/addons/ModuleInformation/server.php");
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_POSTREDIR, 3);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-type: text/xml"]);
        $ret = curl_exec($ch);
        exit("The file " . $file09fa49643e2ec46814978733418b54ae4b444a8f . " is invalid. Please upload the file once again or contact ModulesGarden support.");
    }
}
/**
 * Class to maintain actions for single lead instance
 */
class FieldStatuses extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\FieldStatuses();
    }
    public function query()
    {
        try {
            $statuses = $this->repository->orderBy("order", "ASC")->get();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($statuses->toArray());
    }
    public function queryDashboard($id)
    {
        try {
            $statuses = $this->repository->getWithCounter($id);
            return $this->returnData($statuses);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function add()
    {
        $json = $this->app->request->getBody();
        $data = json_decode($json, true);
        if(!$data["order"]) {
            $data["order"] = 0;
        }
        try {
            $newStatus = $this->repository->create($data);
            $return = ["status" => "success", "msg" => "New Status has been created", "new" => $newStatus->toArray()];
        } catch (\Exception $ex) {
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function delete($id)
    {
        $status = $this->repository->find($id);
        try {
            if(!$status) {
                throw new \Exception("Didnt found requested status");
            }
            $status->safeDelete();
            $return = ["status" => "success", "msg" => "Status has been deleted"];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(404);
            $return = ["status" => "error", "msg" => $e->getMessage()];
        }
        return $this->returnData($return);
    }
    public function massUpdate()
    {
        try {
            $data = json_decode($this->app->request->getBody(), true);
            $toUpdate = array_flip_keys_by($data, "id");
            if(!$this->repository->massUpdate($toUpdate)) {
                throw new \Exception("Something Went Wrong");
            }
            $return = ["status" => "success", "msg" => "Statuses has been updated"];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $e->getMessage()];
        }
        return $this->returnData($return);
    }
    public function reorder()
    {
        try {
            $json = $this->app->request->getBody();
            $data = json_decode($json, true);
            $newOrder = array_flip(array_get($data, "order", []));
            if($this->repository->reorder($newOrder)) {
                $return = ["status" => "success", "msg" => "Order Has has been updated"];
            } else {
                throw new \Exception("Something went wrong.");
            }
        } catch (\Exception $ex) {
            $this->app->response->setStatus(404);
            $return = ["status" => "error", "msg" => $e->getMessage()];
        }
        return $this->returnData($return);
    }
    public function generateSummary($id)
    {
        try {
            $json = $this->app->request->getBody();
            $data = json_decode($json, true);
            $statuses = $this->repository->generateSummaryWithCounters($data);
            return $this->returnData($statuses);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>