<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Resources;

/**
 * Class to maintain actions for single lead instance
 */
class ResourcesLogs extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\Logs();
    }
    public function get()
    {
        try {
            $resultArray = $this->repository->orderBy("date", "DESC")->get();
            $resultArray = $resultArray->toArray();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function parseForTable($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $result = $this->repository->parseForTable($id, $requestData);
            return $this->returnData($result);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>