<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Resources;

/**
 * Class to maintain actions for single lead instance
 */
class ResourcesFollowups extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\Followups();
    }
    public function addWithReminders($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            $new = $this->repository->createWithReminders($id, $requestData);
            if($new) {
                return $this->returnData(["status" => "success", "msg" => "New Follow-up has been created", "new" => $new->toArray()]);
            }
            throw new \Exception("Something went wrong.");
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function addWithoutReminders($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            $new = $this->repository->createFollowup($id, $requestData);
            if($new) {
                return $this->returnData(["status" => "success", "msg" => "New Follow-up has been created", "new" => $new->toArray()]);
            }
            throw new \Exception("Something went wrong.");
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getForTable($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            $this->returnData($this->repository->parseForTable($id, $requestData));
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getSingleFollowup($id, $followupID)
    {
        try {
            $this->returnData($this->repository->getSingle($id, $followupID)->toArray());
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getSingleFollowupWithReminders($id, $followupID)
    {
        try {
            $this->returnData($this->repository->getSingleFollowupWithReminders($id, $followupID)->toArray());
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function updateSingleFollowup($id, $followupID)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            $followup = $this->repository->updateSingleFollowup($id, $followupID, $requestData);
            if($followup) {
                return $this->returnData($followup->toArray());
            }
            throw new \Exception("Something went wrong.");
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function deleteSingleFollowup($id, $followupID)
    {
        try {
            $followup = $this->repository->deleteSingleFollowup($id, $followupID);
            return $this->returnData(["status" => "success", "msg" => "The follow-up has been deleted successfully"]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function reschedueFollowup($id, $followupID)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            $this->repository->reschedueFollowup($id, $followupID, $requestData);
            return $this->returnData(["status" => "success", "msg" => "The follow-up has been rescheduled successfully"]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>