<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Resources;

/**
 * Class to maintain actions for single lead instance
 */
class ResourcesFields extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\FieldDatas();
    }
    public function getAll($id)
    {
        try {
            return $this->returnData($this->repository->getAllForResourceSummary($id));
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function updatefield($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            $return = $this->repository->updateData($id, $requestData);
            $this->synchronizeWithWHMCS($id);
            if(is_array($return)) {
                return $this->returnData($return);
            }
            throw new \Exception("Something went wrong");
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    private function synchronizeWithWHMCS($resourceId)
    {
        $resource = \mgCRM2\Models\Resource::find($resourceId)->toArray();
        $contactSynchro = new \mgCRM2\Services\ContactSync();
        $contactSynchro->contactSyncFromCrmToWhmcs($resource);
    }
}

?>