<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\MassMessages;

class MassMessagesActions extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\MassMessageConfigs();
    }
    public function addConfig()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            $requestData["generated"] = $requestData["generated"] ?: 0;
            $new = $this->repository->addMassMessageConfig($requestData);
            if($new) {
                return $this->returnData(["status" => "success", "msg" => "New Mass Message config has been created", "new" => $new->toArray()]);
            }
            throw new Exception("Something went wrong.");
        } catch (Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getForTable()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            $this->returnData($this->repository->parseForTable($requestData));
        } catch (Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function updateConfig($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $model = $this->repository->updateMassMessagesConfig($id, $requestData);
            return $this->returnData(["status" => "success", "msg" => "Mass Message has been updated", "new" => $model->toArray()]);
        } catch (Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function getSingle($id)
    {
        try {
            return $this->returnData($this->repository->getMassMessagesConfig($id));
        } catch (Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function deleteConfig($id)
    {
        try {
            $this->repository->deleteMassMessagesConfig($id);
            $return = ["status" => "success", "msg" => "Mass Message configuration has been deleted"];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
}

?>