<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Mailbox;

/**
 * Description of MailboxHelpers
 *
 * @author inbs
 */
class ReceiveMessage extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\MailboxRead();
    }
    public function generalData()
    {
        $departments = \mgCRM2\Models\Whmcs\TicketDepartment::orderred()->filterIrrelevantParams()->get()->toArray();
        $templates = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyCrmType()->get()->toArray();
        $smstemplates = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyAdminType()->get()->toArray();
        $mailboxes = \mgCRM2\Models\Mailbox::with("admin")->get();
        $clienttemplates = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyClientType()->get()->toArray();
        $admins = \mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->filterIrrelevantParams()->get()->toArray();
        $campaigns = \mgCRM2\Repositories\Campaigns::obtainCampaignsForAdmin($this->app->currentAdmin->id);
        return $this->returnData(["departments" => $departments, "admins" => $admins, "mailbox" => $mailboxes, "templates" => ["admin" => $templates, "sms" => $smstemplates, "client" => $clienttemplates], "campaigns" => $campaigns]);
    }
    public function get()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $result = $this->repository->getReceiveMessageListTableQuery($requestData);
            return $this->returnData($result);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function sendMessage()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $result = $this->repository->sendMessage($this->utf8ize($requestData));
            return $this->returnData(["status" => "success", "msg" => "Email has been send."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function removeMessage($id)
    {
        try {
            list($message) = \mgCRM2\Models\MailboxRead::where("id", $id)->get();
            $message->delete();
            return $this->returnData(["status" => "success", "msg" => "Email has been removed."]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>