<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Mailbox;

/**
 * Description of MailboxHelpers
 *
 * @author inbs
 */
class MailboxHelpers extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\Mailboxes();
    }
    public function createMailbox()
    {
        $json = $this->app->request->getBody();
        $data = json_decode($json, true);
        try {
            $new = $this->repository->createMailbox($data);
            $return = ["status" => "success", "msg" => "New Mailbox has been created", "new" => $new->toArray()];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function getMailboxList()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $result = $this->repository->getMailboxListTableQuery($requestData);
            return $this->returnData($result);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function getParams()
    {
        try {
            $resultArray = [];
            $resultArray["currentAdmin"] = $this->app->currentAdmin->toArray();
            $admins = \mgCRM2\Models\Whmcs\Admin::select(["id", "roleid", "username", "firstname", "lastname", "email", \Illuminate\Database\Capsule\Manager::raw("CONCAT(firstname, ' ', lastname) as name")])->whereIn("roleid", $this->app->acl->getAssignedAccessRoles())->where("disabled", "=", 0)->get();
            $resultArray["admins"] = $admins->toArray();
            return $this->returnData($resultArray);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getMailboxListByAdmin()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $result = $this->repository->getMailboxByAdmin(array_get($requestData, "admin_id", 0));
            return $this->returnData($result);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function getMailbox($id)
    {
        try {
            $result = $this->repository->getMailbox($id);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($result->toArray());
    }
    public function updateMailbox($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $mailbox = $this->repository->updateMailbox($id, $requestData);
            return $this->returnData(["status" => "success", "msg" => "The mailbox has been updated successfully", "new" => $mailbox->toArray()]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function deleteMailbox($id)
    {
        try {
            $this->deleteLinkedItems($id);
            $new = $this->repository->deleteMailbox($id);
            $return = ["status" => "success", "msg" => "Mailbox has been deleted"];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    protected function deleteLinkedItems($mailboxId)
    {
        $attachmentsRepo = new \mgCRM2\Repositories\Attachments();
        $mailReadRepo = new \mgCRM2\Repositories\MailboxRead();
        $attachmentsRepo->deleteAllFromMailbox($mailboxId);
        $mailReadRepo->deleteAllMessagesFromMailbox($mailboxId);
    }
    public function testSend($id)
    {
        require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
        try {
            $new = $this->repository->testMail($id);
            $bool = $new["return"];
            $return = ["status" => $bool ? "success" : "danger", "msg" => $bool ? "Email has been send to  " . $new["email"] : ($new["error"] ? $new["error"] : "Fail send!")];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
}

?>