<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Helpers;

/**
 * Helper controller
 * to obtain various pack of data from DB
 */
class Whmcs extends \mgCRM2\Controllers\Source\AbstractController
{
    public function getCustomFields()
    {
        try {
            $results = \Illuminate\Database\Capsule\Manager::table("tblcustomfields")->select(["id", "fieldname"])->where("type", "=", "client")->orderBy("sortorder")->get();
            return $this->returnData(["status" => "success", "fields" => $results]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($results);
    }
    private function encodeCustomFields($fields)
    {
        foreach ($fields as $customField) {
            $customField->fieldname = utf8_encode($customField->fieldname);
        }
    }
}

?>