<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Helpers;

/**
 * Class to maintain actions for single lead instance
 */
class Data extends \mgCRM2\Controllers\Source\AbstractController
{
    public function getLeadUsefull()
    {
        try {
            $repository = new \mgCRM2\Repositories\Settings();
            $configs = $repository->getAdminPersonalizedSettings($this->app->currentAdmin->id)->toArray();
            $number = 1;
            $mailboxs = \mgCRM2\Models\Mailbox::filterIrrelevantParams($this->app->currentAdmin->toArray()["id"])->get()->toArray();
            $defaultMailBoxs = 0;
            if(count($mailboxs)) {
                foreach ($mailboxs as $id => $data) {
                    $mailboxs[$id]["type_name"] = "m";
                    $mailboxs[$id]["number"] = $number;
                    $number++;
                }
            }
            $tickets = \mgCRM2\Models\Whmcs\TicketDepartment::orderred()->filterIrrelevantParams()->get()->toArray();
            if(count($tickets)) {
                foreach ($tickets as $id => $data) {
                    $tickets[$id]["type_name"] = "t";
                    $tickets[$id]["number"] = $number;
                    $number++;
                }
            }
            $departments = array_merge($mailboxs, $tickets);
            if(isset($configs["defaultEmail"]) && $configs["defaultEmail"] != "") {
                foreach ($departments as $department) {
                    if($configs["defaultEmail"] === $department["fullemail"]) {
                        $defaultMailBoxs = $department["number"];
                    }
                }
            }
            $statusesRepo = new \mgCRM2\Repositories\FieldStatuses();
            $statuses = $statusesRepo->orderBy("order", "ASC")->get()->toArray();
            $systemEmail = \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->where("setting", "=", "Email")->take(1)->first(["value"]);
            $templates = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyCrmType()->get()->toArray();
            $smstemplates = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyAdminType()->get()->toArray();
            $clienttemplates = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyClientType()->get()->toArray();
            $admins = \mgCRM2\Models\Whmcs\Admin::filterIrrelevantParams()->where("disabled", "0")->get()->toArray();
            $followupTypes = \mgCRM2\Models\FollowupType::orderred()->get()->toArray();
            $followupStatuses = \mgCRM2\Models\FollowupStatus::orderred()->get()->toArray();
            $campaigns = \mgCRM2\Repositories\Campaigns::obtainAllCampaignsListForAdmin($this->app->currentAdmin->id);
            $labels = \mgCRM2\Helpers\LabelHelper::addLabelColor(\mgCRM2\Models\Label::all()->toArray());
            $result = ["statuses" => $statuses, "departments" => $departments, "default_mail" => $defaultMailBoxs, "admins" => $admins, "system_email" => $systemEmail->value, "followupTypes" => $followupTypes, "followupStatuses" => $followupStatuses, "labels" => $labels, "campaigns" => $campaigns->toArray(), "templates" => ["admin" => $templates, "sms" => $smstemplates, "client" => $clienttemplates]];
            return $this->returnData($result);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getResourcesTableHelpers()
    {
        try {
            $statusesRepo = new \mgCRM2\Repositories\FieldStatuses();
            $statuses = $statusesRepo->orderBy("order", "ASC")->get()->toArray();
            $admins = \mgCRM2\Models\Whmcs\Admin::onlyActive()->filterIrrelevantParams()->get()->toArray();
            $campaigns = \mgCRM2\Repositories\Campaigns::obtainCampaignsForAdmin($this->app->currentAdmin->id);
            $labels = \mgCRM2\Helpers\LabelHelper::addLabelColor(\mgCRM2\Models\Label::all()->toArray());
            $result = ["statuses" => $statuses, "admins" => $admins, "campaigns" => $campaigns, "labels" => $labels];
            return $this->returnData($result);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getMassMessagesHelpers()
    {
        try {
            $mailboxs = \mgCRM2\Models\Mailbox::get()->toArray();
            $clientGrpsCollection = new \Illuminate\Support\Collection(\Illuminate\Database\Capsule\Manager::table("tblclientgroups")->select(["tblclientgroups.id", "tblclientgroups.groupname as name"])->get());
            $clientgroups = $clientGrpsCollection->map(function ($item, $key) {
                return ["id" => intval($item->id), "name" => $item->name];
            });
            $campaigns = \mgCRM2\Models\Campaign::all()->map(function ($item, $key) {
                return ["id" => $item->id, "name" => $item->name];
            });
            return $this->returnData(["mailbox" => $mailboxs, "clientgroups" => $clientgroups->toArray(), "campaigns" => $campaigns->toArray()]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>