<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Helpers;

/**
 * Class to maintain actions for single lead instance
 */
class DashboardHelper extends \mgCRM2\Controllers\Source\AbstractController
{
    public function backgroundData()
    {
        $departments = \mgCRM2\Models\Whmcs\TicketDepartment::orderred()->filterIrrelevantParams()->get()->toArray();
        $templates = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyCrmType()->get()->toArray();
        $smstemplates = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyAdminType()->get()->toArray();
        $clienttemplates = \mgCRM2\Models\Whmcs\EmailTemplates::forSelect()->onlyClientType()->get()->toArray();
        $admins = \mgCRM2\Models\Whmcs\Admin::filterIrrelevantParams()->where("disabled", "0")->get()->toArray();
        $followupTypes = \mgCRM2\Models\FollowupType::orderred()->get()->toArray();
        $followupStatuses = \mgCRM2\Models\FollowupStatus::orderred()->get()->toArray();
        $campaigns = \mgCRM2\Repositories\Campaigns::obtainCampaignsForAdmin($this->app->currentAdmin->id);
        $labels = \mgCRM2\Helpers\LabelHelper::addLabelColor(\mgCRM2\Models\Label::all()->toArray());
        return $this->returnData(["departments" => $departments, "admins" => $admins, "labels" => $labels, "followup" => ["types" => $followupTypes, "statuses" => $followupStatuses], "templates" => ["admin" => $templates, "sms" => $smstemplates, "client" => $clienttemplates], "campaigns" => $campaigns]);
    }
}

?>