<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Files;

/**
 * Class to maintain actions for single lead instance
 */
class Manage extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\Files();
    }
    public function getMaximumFileSize()
    {
        try {
            return $this->returnData(["sizeString" => file_upload_max_size(false), "size" => file_upload_max_size(true)]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage(), "trace" => $ex->getTrace()]);
        }
    }
    public function uploadFile($id)
    {
        try {
            if(is_array($_FILES) && !empty($_FILES)) {
                $files = $_FILES;
            } else {
                $files = [];
            }
            if(is_array($_REQUEST) && !empty($_REQUEST)) {
                $request = $_REQUEST;
            } else {
                $request = [];
            }
            $new = $this->repository->addFileForResource($id, $files, $request);
            if($new) {
                return $this->returnData(["status" => "success", "msg" => "File has been added", "new" => $new->toArray()]);
            }
            throw new \Exception("Something went wrong.");
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage(), "trace" => $ex->getTrace()]);
        }
    }
    public function parseForTable($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            if(empty($requestData)) {
                $requestData = [];
            }
            $this->returnData($this->repository->parseForTable($id, $requestData));
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function getFile($id, $fileId)
    {
        try {
            $this->returnData($this->repository->getFile($id, $fileId));
        } catch (\Exception $ex) {
            $this->app->response->setStatus(404);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
    public function deleteFile($id, $fileId)
    {
        try {
            $this->repository->deleteFile($id, $fileId);
            return $this->returnData(["status" => "success", "msg" => "File has been deleted"]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(404);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
    }
}

?>