<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Controllers\Api\Campaigns;

/**
 * Class to maintain actions for single lead instance
 */
class CampaignsHelpers extends \mgCRM2\Controllers\Source\AbstractController
{
    public function __construct()
    {
        parent::__construct();
        $this->repository = new \mgCRM2\Repositories\Campaigns();
    }
    public function getAllColumnsForFilters()
    {
        try {
            $available = \mgCRM2\Helpers\TablesFieldViews::getAllColumnsForFilters();
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($available);
    }
    public function ResourcesTableQueryByFilters()
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $result = $this->repository->ResourcesTableQueryByFilters($requestData);
            return $this->returnData($result);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function createCampaign()
    {
        $json = $this->app->request->getBody();
        $data = json_decode($json, true);
        try {
            $new = $this->repository->createCampaign($data);
            $return = ["status" => "success", "msg" => "New Campaign has been created", "new" => $new->toArray()];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function getCampaignList()
    {
        try {
            if($this->app->config("isWhmcsAPIcall") === true) {
                return $this->returnData($this->repository->getCampaignsForAPI());
            }
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $result = $this->repository->getCampaignListTableQuery($requestData);
            return $this->returnData($result);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function refreshCampaignAssignments($id)
    {
        try {
            $result = $this->repository->syncCampaignResourcesByFilters($id);
            if($result === true) {
                return $this->returnData(["status" => "success", "msg" => "Records synchronization with the campaign filters has been  completed"]);
            }
            throw new \Exception("Something went wrong");
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function getCampaign($id)
    {
        try {
            $resultArray = $this->repository->getCampaign($id);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function updateCampaign($id)
    {
        try {
            $requestData = json_decode($this->app->request->getBody(), true);
            $requestData = is_array($requestData) ? $requestData : [];
            $campaign = $this->repository->updateCampaign($id, $requestData);
            return $this->returnData(["status" => "success", "msg" => "The campaign has been updated successfully", "new" => $campaign->toArray()]);
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            return $this->returnData(["status" => "error", "msg" => $ex->getMessage()]);
        }
        return $this->returnData($resultArray);
    }
    public function deleteCampaign($id)
    {
        try {
            $new = $this->repository->deleteCampaign($id);
            $return = ["status" => "success", "msg" => "Campaign has been deleted"];
        } catch (\Exception $ex) {
            $this->app->response->setStatus(409);
            $return = ["status" => "error", "msg" => $ex->getMessage()];
        }
        return $this->returnData($return);
    }
    public function getFilteredCampaign()
    {
        return $this->returnData(["filteredCampaigns" => \mgCRM2\Repositories\Campaigns::obtainCampaignsForAdmin($this->app->currentAdmin->id)]);
    }
}

?>